@extends('super_admins.layouts.master')

@section('title')
    Edit Maintenance Setting
@endsection

@section('css')
    <!-- daterange picker -->
    <link rel="stylesheet" href="{{ asset('plugins/daterangepicker/daterangepicker.css') }}">
    <!-- Tempusdominus Bootstrap 4 -->
    <link rel="stylesheet" href="{{ asset('plugins/tempusdominus-bootstrap-4/css/tempusdominus-bootstrap-4.min.css') }}">
    <style>

.datetimepicker {
	display: inline-flex;
	align-items: center;
	background-color: #fff;
	border: 4px solid darkturquoise;
	border-radius: 8px;
	
	&:focus-within {
		border-color: teal;
	}
	
	input {
		font: inherit;
		color: inherit;
		appearance: none;
		outline: none;
		border: 0;
		background-color: transparent;
		
		&[type=date] {
			width: 10rem;
			padding: .25rem 0 .25rem .5rem;
			border-right-width: 0;
		}
		
		&[type=time] {
			width: 5.5rem;
			padding: .25rem .5rem .25rem 0;
			border-left-width: 0;
		}
	}
	
	span {
		height: 1rem;
		margin-right: .25rem;
		margin-left: .25rem;
		border-right: 1px solid #ddd;
	}
}

.info {
	padding-top: .5rem;
	font-size: .8rem;
	color: rgba(255, 255, 255, .5);
}
    </style>
@endsection

@section('content')
    @if ($errors->any())
        @foreach ($errors->all() as $error)
            {{-- {{ $error }} --}}
        @endforeach
    @endif
    <section class="content-header">
        <div class="container-fluid">
            <div class="row mb-4 pt-4 pt-lg-0">

                <div class="col-sm-6">
                    <h2 class="main-content-title fw-bold mb-0">Maintenance Setting</h2>
                    <ol class="breadcrumb float-sm-left">
                        <li class="breadcrumb-item"><a href="{{ route('super_admin.dashboard') }}">Home</a></li>

                        <li class="breadcrumb-item active">
                            Maintenance Setting
                        </li>
                    </ol>
                </div>
            </div>
        </div><!-- /.container-fluid -->
    </section>

    <section class="content">
        
        <div class="container-fluid">
            <div class="row">
                <!-- left column -->
                <div class="col-md-12">
                    <!-- jquery validation -->
                    
                    <div class="card card-secondary">

                        <!-- form start -->
                        <form id="quickForm" method="POST" action="{{ route('super_admin.maintenance_settings.update') }}"
                            enctype="multipart/form-data">
                            @csrf
                            @method('PUT')
                            <div class="col-md-12 col-lg-4">
                                <div class="form-group">
                                    
                                    <div class="custom-control custom-switch">
                                        <input type="checkbox" name="is_active" value="1"
                                            @if ($maintenance_setting->is_active) checked @endif
                                            class="custom-control-input" id="customSwitch1"
                                            aria-describedby="IsActiveError" aria-invalid="true">
                                        <label class="custom-control-label" for="customSwitch1">Maintenance Mode is On/Off
                                            </label>
                                    </div>
                                </div>
                            </div>
                            <div id="form-body" class="card-body">

                                <div class="row">
                                    <div class="w-100">
                                        <h5>Multi Language</h5>
                                        <div>
                                            <ul class="nav nav-tabs" id="myTab" role="tablist">
                                                @foreach ($active_languages as $key => $language)
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link {{ $key == 0 ? 'active' : '' }} mr-1"
                                                            id="nav-{{ $language->code }}-tab" data-toggle="tab"
                                                            data-target="#nav-{{ $language->code }}" type="button"
                                                            role="tab" aria-controls="nav-{{ $language->code }}"
                                                            aria-selected="true">{{ $language->name }}</button>
                                                    </li>
                                                @endforeach
                                            </ul>
                                            <div class="tab-content mt-2 p-2" id="myTabContent">
                                                @foreach ($active_languages as $key => $language)
                                                    <div class="tab-pane fade mb-2 {{ $key == 0 ? 'show active' : '' }}"
                                                        id="nav-{{ $language->code }}" role="tabpanel"
                                                        aria-labelledby="nav-{{ $language->code }}-tab">
                                                        <div class="form-group">
                                                            <label for="InputName-{{ $language->code }}">Name
                                                                ({{ $language->code }})</label>
                                                            <input type="text" name="name[{{ $language->code }}]"
                                                                value="{{ $maintenance_setting->getTranslation('name', $language->code) }}"
                                                                class="form-control @if ($errors->has('name.' . $language->code)) is-invalid @endif"
                                                                id="InputName-{{ $language->code }}"
                                                                placeholder="Please Enter"
                                                                aria-describedby="NameError-{{ $language->code }}"
                                                                aria-invalid="true">
                                                            <span id="NameError-{{ $language->code }}"
                                                                class="error invalid-feedback">
                                                                @if ($errors->has('name.' . $language->code))
                                                                    {{ $errors->first('name.' . $language->code) }}
                                                                @endif
                                                            </span>
                                                        </div>
                                                        <div class="form-group">
                                                            <label for="InputDescription">Description
                                                                ({{ $language->code }})</label>
                                                            <textarea name="description[{{ $language->code }}]" id="discription_editor_{{ $language->code }}"
                                                                class="form-control @if ($errors->has('description.' . $language->code)) is-invalid @endif" rows="3" placeholder="Please Enter"
                                                                aria-describedby="DescriptionError-{{ $language->code }}" aria-invalid="true">{{ $maintenance_setting->getTranslation('description', $language->code) }}</textarea>
                                                            <span id="DescriptionError-{{ $language->code }}"
                                                                class="error invalid-feedback">
                                                                @if ($errors->has('description.' . $language->code))
                                                                    {{ $errors->first('description.' . $language->code) }}
                                                                @endif
                                                            </span>
                                                        </div>
                                                    </div>
                                                @endforeach
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                   
                                    <div class="col-md-12 col-lg-4">
                                        <div class="form-group">
                                            <label for="InputImage">Choose Picture</label>
                                            <input type="hidden" name="image" class="image" value="">
                                            <input type="file" name="imageFile"
                                                class="custom-file-input imageFile @if ($errors->has('image')) is-invalid @endif"
                                                id="InputImage" placeholder="Select image" aria-describedby="ImageError"
                                                aria-invalid="true">
                                            <span id="ImageError" class="error invalid-feedback">
                                                @if ($errors->has('image'))
                                                    {{ $errors->first('image') }}
                                                @endif
                                            </span>
                                            @if ($maintenance_setting->image)
                                                <div class="custom-file-preview">
                                                    <img src="{{ url($maintenance_setting->image) }}" width="75px"
                                                        height="75px" alt="{{ $maintenance_setting->name }}">
                                                </div>
                                            @else
                                                <div class="custom-file-preview">
                                                    -- No Image Selected
                                                </div>
                                            @endif

                                        </div>
                                    </div>
                                    <div class="col-md-12 col-lg-4">
                                        <div class="form-group">
                                            <label for="InputImage">Choose Icon</label>
                                            <input type="hidden" name="icon" class="image" value="">
                                            <input type="file" name="iconFile"
                                                class="custom-file-input imageFile @if ($errors->has('icon')) is-invalid @endif"
                                                id="InputIcon" placeholder="Select image" aria-describedby="IconError"
                                                aria-invalid="true">
                                            <span id="ImageError" class="error invalid-feedback">
                                                @if ($errors->has('icon'))
                                                    {{ $errors->first('icon') }}
                                                @endif
                                            </span>
                                            @if ($maintenance_setting->icon)
                                                <div class="custom-file-preview">
                                                    <img src="{{ url($maintenance_setting->icon) }}" width="75px"
                                                        height="75px" alt="{{ $maintenance_setting->icon }}">
                                                </div>
                                            @else
                                                <div class="custom-file-preview">
                                                    -- No Image Selected
                                                </div>
                                            @endif

                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-12 col-lg-4">
                                    <div class="form-group">
                                        
                                        <div class="custom-control custom-switch">
                                            <input type="checkbox" name="is_datetime" value="1"
                                            @if ($maintenance_setting->is_datetime) checked @endif
                                                class="custom-control-input" id="timeSwitch1"
                                                aria-describedby="IsActiveError" aria-invalid="true">
                                            <label class="custom-control-label" for="timeSwitch1">Launching Time
                                                </label>
                                        </div>
                                    </div>
                                    <div class="card shadow" id="dateTime">
                                        <div class="card-body">
                                            <div class="row">
                                                <div class="datetimepicker">
                                                    <input type="date" id="date" name="end_date" value="{{ $maintenance_setting->end_date ?? '' }}">
                                                    <span></span>
                                                    <input type="time" id="time" name="end_time" value="{{ $maintenance_setting->end_time ?? '' }}">
                                                </div>
                                               
                                            </div>

                                          {{-- <input type="date" class="form-control" name="start_time" id="start_time">                 
                                          <input type="time" class="form-control" name="start_time" id="start_time">                  --}}
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-12">

                                <button type="submit" class="btn btn-primary px-3 py-1">Update</button>
                            </div>
                        </form>
                    </div>
                    <!-- /.card -->
                </div>
                <!--/.col (left) -->
                <!-- right column -->
                <div class="col-md-6">

                </div>
                <!--/.col (right) -->
            </div>
            <!-- /.row -->
        </div><!-- /.container-fluid -->
    </section>
    @include('super_admins.includes.image_cropper_modal')
@endsection

@section('scripts')
    <script src="{{ asset('plugins/bs-custom-file-input/bs-custom-file-input.min.js') }}"></script>
    <!-- date-range-picker -->
    <script src="{{ asset('plugins/moment/moment.min.js') }}"></script>
    <script src="{{ asset('plugins/tempusdominus-bootstrap-4/js/tempusdominus-bootstrap-4.min.js') }}"></script>
    <script>
        $(document).ready(function() {
            @foreach ($active_languages as $language)
                ClassicEditor.create(document.querySelector('#discription_editor_{{ $language->code }}')).catch(
                    error => {
                        console.error(error);
                    });
                // ClassicEditor.create(document.querySelector('#short_description_editor_{{ $language->code }}')).catch(error => { console.error(error); });
            @endforeach
        });
    </script>
    <script>
        document.addEventListener("DOMContentLoaded", function () {
            let toggleSwitch = document.getElementById("customSwitch1");
            let formContainer = document.getElementById("form-body");
    
            function toggleFormVisibility() {
                if (toggleSwitch.checked) {
                    formContainer.style.display = "block";
                } else {
                    formContainer.style.display = "none";
                }
            }
    
            toggleSwitch.addEventListener("change", toggleFormVisibility);
            toggleFormVisibility(); // Initial check


            let timeSwitch = document.getElementById("timeSwitch1");
            let dateTime = document.getElementById("dateTime");
            let datePicker = document.querySelector('.datetimepicker');
            function toggleDateTime() {
                if (timeSwitch.checked) {
                    dateTime.style.display = "block";
                    datePicker.style.display = "block";
                } else {
                    dateTime.style.display = "none";
                    datePicker.style.display = "none";
                }
            }
            timeSwitch.addEventListener("change", toggleDateTime);
            toggleDateTime(); // Initial check

        });
        var dateEl = document.getElementById('date');
var timeEl = document.getElementById('time');

document.getElementById('date-output').innerHTML = dateEl.type === 'date';
document.getElementById('time-output').innerHTML = timeEl.type === 'time';
    </script>
    
    @include('super_admins.includes.image_cropper_scripts')
@endsection
